<?php
/**
 * Plugin Name:           AutomatorWP - AWeber
 * Plugin URI:            https://automatorwp.com/add-ons/aweber/
 * Description:           Connect AutomatorWP with AWeber.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-aweber
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\AWeber
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_AWeber {

    /**
     * @var         AutomatorWP_AWeber $instance The one true AutomatorWP_AWeber
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_AWeber self::$instance The one true AutomatorWP_AWeber
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_AWeber();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_AWEBER_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_AWEBER_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_AWEBER_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_AWEBER_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/add-user-list.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/delete-user-list.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/add-subscriber-list.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/delete-subscriber-list.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/add-user-tag.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/remove-user-tag.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/add-subscriber-tag.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/remove-subscriber-tag.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/update-user-custom-field.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/update-subscriber-custom-field.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/update-user-email.php';
            require_once AUTOMATORWP_AWEBER_DIR . 'includes/actions/update-subscriber-email.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'aweber', array(
            'label' => 'AWeber',
            'icon'  => AUTOMATORWP_AWEBER_URL . 'assets/aweber.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_AWeber instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_AWeber The one true AutomatorWP_AWeber
 */
function AutomatorWP_AWeber() {
    return AutomatorWP_AWeber::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_AWeber' );
